<?php

require_once 'config.php';

/* Load categories and items in structured array */
$cats = [];

$catRes = $conn->query("SELECT * FROM categories ORDER BY sort_order");

while ($c = $catRes->fetch_assoc()) {

  $cats[$c['id']] = $c;

  $cats[$c['id']]['items'] = [];
}

$itemRes = $conn->query("SELECT * FROM items WHERE active=1 ORDER BY category_id, sort_order");

while ($it = $itemRes->fetch_assoc()) {

  if (isset($cats[$it['category_id']])) {

    $cats[$it['category_id']]['items'][] = $it;
  }
}
?>


<!doctype html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <title>Cleaning Calculator</title>
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="assets/css/style.css?ver=<?= time(); ?>" rel="stylesheet">
</head>

<body>
  <div class="container py-4">
    <div class="d-flex justify-content-end mt-3 mb-3">
      <a href="admin/index.php" class="btn btn-primary" target="_blank">
        Go to Admin Panel
      </a>
    </div>
    <div class="calc-columns">
      
      <!-- Left column: Bedrooms, Bathrooms, Sqft, Zipcode -->
      <div class="calc-left">
        <div class="card left-card">
          <h4>Cleaning Details</h4>
          <form id="calcForm">
            <?php foreach ($cats as $cat): ?>
              <?php if (in_array($cat['slug'], ['bedrooms', 'bathrooms', 'sqft', 'zipcodes'])): ?>
                <div class="mb-3">
                  <label class="form-label fw-semibold"><?= esc($cat['title']) ?></label>
                  <?php if ($cat['input_type'] === 'select' || $cat['input_type'] === 'zipcode'): ?>
                    <select class="form-select calc-field" data-category="<?= esc($cat['slug']) ?>">
                      <option value="">-- Select --</option>
                      <?php foreach ($cat['items'] as $it): ?>
                        <option data-price="<?= esc($it['price']) ?>" value="<?= esc($it['id']) ?>"><?= esc($it['label']) ?><?= ($it['value_key'] ? ' (' . esc($it['value_key']) . ')' : '') ?></option>
                      <?php endforeach; ?>
                    </select>
                  <?php endif; ?>
                </div>
              <?php endif; ?>
            <?php endforeach; ?>
            <!--<button type="button" id="resetBtn" class="btn btn-outline-secondary mt-2">Reset</button>-->
          </form>
        </div>
      </div>
    
      <!-- Center column: Frequency + Extras -->
      <div class="calc-center">
        <!-- Frequency Card -->
        <?php foreach ($cats as $cat): ?>
          <?php if ($cat['slug'] === 'frequency'): ?>
            <div class="card freq-card">
              <h4><?= esc($cat['title']) ?></h4>
              <div class="freq-toggle">
                <?php foreach ($cat['items'] as $it): ?>
                  <div>
                    <input type="radio" class="btn-check calc-field" 
                      name="frequency" 
                      id="freq-<?= esc($it['id']) ?>" 
                      data-price="<?= esc($it['price']) ?>"
                      data-category="<?= esc($cat['slug']) ?>" value="<?= esc($it['id']) ?>">
                    <label class="btn" for="freq-<?= esc($it['id']) ?>">
                      <?= esc($it['label']) ?> (<?= esc($it['price']) ?>%)
                    </label>
                  </div>
                <?php endforeach; ?>
              </div>
            </div>
          <?php endif; ?>
        <?php endforeach; ?>

        <!-- Extras Card -->
        <?php foreach ($cats as $cat): ?>
          <?php if ($cat['slug'] === 'extras'): ?>
            <div class="card extras-card">
              <h4><?= esc($cat['title']) ?></h4>
              <div class="extras-container">
                <?php foreach ($cat['items'] as $it): ?>
                  <div class="extras-box position-relative text-center">
                    <!-- Quantity selector ABOVE the box -->
                    <div class="quantity-selector align-items-center justify-content-center">
                      <button type="button" class="qty-minus">−</button>
                      <input type="number"
                        min="1"
                        max="<?= esc($it['max_qty'] ?? 10) ?>"
                        value="1"
                        class="qty-input"
                        readonly
                        style="text-align:center;">
                      <button type="button" class="qty-plus">+</button>
                    </div>
                    <!-- Checkbox and label -->
                    <input type="checkbox" class="extras-box-input d-none"
                      id="extra-<?= esc($it['id']) ?>"
                      data-price="<?= esc($it['price']) ?>"
                      data-item-id="<?= esc($it['id']) ?>"
                      data-max="<?= esc($it['max_qty'] ?? 10) ?>">
                    <label class="extras-box-label w-100" for="extra-<?= esc($it['id']) ?>">
                      <?= esc($it['label']) ?><br>
                      <?= ($it['price'] > 0 ? '($' . esc($it['price']) . ')' : '(0)') ?>
                    </label>
                  </div>
                <?php endforeach; ?>
              </div>
            </div>
          <?php endif; ?>
        <?php endforeach; ?>
      </div>
      
      <!-- Right column: Summary -->
      <div class="calc-right">
        <div class="card summary-card">
          <h4>Summary</h4>
          <ul class="list-group mb-3" id="summaryList"></ul>
          <div class="d-flex justify-content-between align-items-center">
            <div>Subtotal:</div>
            <div id="subtotal">$0.00</div>
          </div>
          <div class="d-flex justify-content-between align-items-center">
            <div>Discount (frequency):</div>
            <div id="discount">-$0.00</div>
          </div>
          <hr>
          <div class="d-flex justify-content-between align-items-center fs-4 fw-bold">
            <div>Total:</div>
            <div id="total">$0.00</div>
          </div>
          <!-- Buttons at the bottom -->
          <div class="d-flex flex-column gap-2 mt-3">
            <button type="button" id="resetBtn" class="btn btn-outline-secondary w-100">Reset</button>
          </div>
        </div>
      </div>
    </div>
  </div>

  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
  <script src="assets/js/app.js?ver=<?= time(); ?>"></script>

</body>

</html>