<?php
// admin/edit_item.php
require_once '../config.php';
if(!isset($_SESSION['admin_user'])) header('Location: index.php');

$id = isset($_GET['id'])? intval($_GET['id']) : 0;
$category_id = isset($_GET['category_id'])? intval($_GET['category_id']) : 0;
$error = '';
$success = '';

if($_SERVER['REQUEST_METHOD'] === 'POST'){
  $label = $conn->real_escape_string($_POST['label']);
  $value_key = isset($_POST['value_key'])? $conn->real_escape_string($_POST['value_key']):'';
  $price = floatval($_POST['price']);
  $active = isset($_POST['active'])?1:0;
  $category_id = intval($_POST['category_id']);
  if($id){
    $conn->query("UPDATE items SET label='{$label}', value_key='{$value_key}', price='{$price}', active='{$active}' WHERE id={$id}");
    $success = 'Updated';
  } else {
    $conn->query("INSERT INTO items (category_id,label,value_key,price,active) VALUES ({$category_id},'{$label}','{$value_key}','{$price}','{$active}')");
    $success = 'Added';
    $id = $conn->insert_id;
  }
}

$item = null;
if($id){
  $res = $conn->query("SELECT * FROM items WHERE id={$id} LIMIT 1");
  $item = $res->fetch_assoc();
}
$cats = $conn->query("SELECT * FROM categories ORDER BY sort_order");
?>
<!doctype html><html><head>
  <meta charset="utf-8"><title>Edit Item</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head><body class="bg-light">
<div class="container py-4">
  <a href="dashboard.php" class="btn btn-sm btn-outline-secondary mb-3">← Back</a>
  <div class="card p-3">
    <h5><?= $item ? 'Edit' : 'Add' ?> Item</h5>
    <?php if($error):?><div class="alert alert-danger"><?=$error?></div><?php endif;?>
    <?php if($success):?><div class="alert alert-success"><?=$success?></div><?php endif;?>

    <form method="post">
      <div class="mb-2">
        <label>Category</label>
        <select name="category_id" class="form-select" required>
          <?php while($c=$cats->fetch_assoc()): ?>
            <option value="<?=esc($c['id'])?>" <?=($item && $item['category_id']==$c['id'])||($category_id==$c['id'] && !$item)?'selected':''?>><?=esc($c['title'])?> (<?=esc($c['slug'])?>)</option>
          <?php endwhile; ?>
        </select>
      </div>
      <div class="mb-2">
        <label>Label</label>
        <input class="form-control" name="label" value="<?=esc($item['label'] ?? '')?>" required>
      </div>
      <div class="mb-2">
        <label>Value Key (optional - e.g. zipcode)</label>
        <input class="form-control" name="value_key" value="<?=esc($item['value_key'] ?? '')?>">
      </div>
      <div class="mb-2">
        <label>Price (for frequency store discount %)</label>
        <input class="form-control" name="price" value="<?=esc($item['price'] ?? '0.00')?>" required>
      </div>
      <div class="form-check mb-3">
        <input type="checkbox" class="form-check-input" id="active" name="active" <?=(!isset($item['active']) || $item['active'])? 'checked':''?>>
        <label class="form-check-label" for="active">Active</label>
      </div>
      <button class="btn btn-primary"><?= $item ? 'Save' : 'Add' ?></button>
    </form>
  </div>
</div>
</body></html>
