<?php
// admin/edit_category.php
require_once '../config.php';
if(!isset($_SESSION['admin_user'])) header('Location: index.php');

$id = isset($_GET['id']) ? intval($_GET['id']) : 0;
$title = '';
$input_type = 'select';
$sort_order = 0;
$error = '';
$success = '';

if($id) {
    $r = $conn->query("SELECT * FROM categories WHERE id=" . intval($id) . " LIMIT 1");
    if($r && $row = $r->fetch_assoc()){
        $title = $row['title'];
        $input_type = $row['input_type'];
        $sort_order = $row['sort_order'];
    }
}

if($_SERVER['REQUEST_METHOD'] === 'POST'){
    $title = $conn->real_escape_string($_POST['title'] ?? '');
    $input_type = $conn->real_escape_string($_POST['input_type'] ?? 'select');
    $sort_order = intval($_POST['sort_order'] ?? 0);

    if(trim($title) === '') {
        $error = 'Title is required.';
    } else {
        if($id){
            $conn->query("UPDATE categories SET title='{$title}', input_type='{$input_type}', sort_order={$sort_order} WHERE id={$id} LIMIT 1");
            $success = 'Category updated.';
        } else {
            $conn->query("INSERT INTO categories (title, input_type, sort_order) VALUES ('{$title}', '{$input_type}', {$sort_order})");
            $id = $conn->insert_id;
            $success = 'Category added.';
        }
        header("Location: dashboard.php?msg=" . urlencode($success));
        exit;
    }
}
?>
<!doctype html>
<html>
<head>
  <meta charset="utf-8">
  <title><?= $id ? 'Edit' : 'Add' ?> Category</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<div class="container py-4">
  <a href="dashboard.php" class="btn btn-sm btn-secondary mb-3">&larr; Back</a>
  <div class="card p-4">
    <h4><?= $id ? 'Edit' : 'Add' ?> Category</h4>
    <?php if($error): ?><div class="alert alert-danger"><?= esc($error) ?></div><?php endif; ?>
    <form method="post">
      <div class="mb-3">
        <label class="form-label">Title</label>
        <input name="title" class="form-control" value="<?= esc($title) ?>" required>
      </div>
      <div class="mb-3">
        <label class="form-label">Input Type</label>
        <select name="input_type" class="form-select">
          <option value="select" <?= $input_type === 'select' ? 'selected' : '' ?>>select</option>
          <option value="zipcode" <?= $input_type === 'zipcode' ? 'selected' : '' ?>>zipcode</option>
          <option value="radio" <?= $input_type === 'radio' ? 'selected' : '' ?>>radio</option>
        </select>
      </div>
      <div class="mb-3">
        <label class="form-label">Sort Order</label>
        <input name="sort_order" type="number" class="form-control" value="<?= intval($sort_order) ?>">
      </div>
      <button class="btn btn-primary"><?= $id ? 'Save' : 'Add' ?></button>
    </form>
  </div>
</div>
</body>
</html>
