<?php
require_once '../config.php';

if (!isset($_SESSION['admin_user'])) {
    header('Location: index.php');
    exit;
}

// Get current setting
$rangeMargin = 15; // default fallback
$res = $conn->query("SELECT value FROM settings WHERE name='price_range_margin'");
if ($res && $row = $res->fetch_assoc()) {
    $rangeMargin = (float)$row['value'];
}

// Save new value if submitted
$msg = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['price_range_margin'])) {
    $newVal = (float)$_POST['price_range_margin'];
    $conn->query("
        INSERT INTO settings (name, value)
        VALUES ('price_range_margin', '$newVal')
        ON DUPLICATE KEY UPDATE value='$newVal'
    ");
    $rangeMargin = $newVal;
    $msg = "✅ Range margin updated to {$newVal}%";
}
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <title>Calculator Settings</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body { background: #f8f9fa; }
    .card { box-shadow: 0 2px 6px rgba(0,0,0,0.06); border-radius: 10px; }
  </style>
</head>
<body>
<div class="container py-4">
  <div class="d-flex justify-content-between align-items-center mb-4">
    <h3 class="mb-0">⚙️ Calculator Settings</h3>
    <div>
      <a href="../index.php" target="_blank" class="btn btn-sm btn-outline-success me-2">
      🔢 View Calculator
      </a>
      <a href="dashboard.php" class="btn btn-sm btn-outline-primary me-2">Dashboard</a>
      <a href="settings.php" class="btn btn-sm btn-outline-info me-2">Settings</a>
      <a href="profile.php" class="btn btn-sm btn-outline-secondary me-2">Profile</a>
      <a href="logout.php" class="btn btn-sm btn-danger">Logout</a>
    </div>
  </div>

  <?php if ($msg): ?>
    <div class="alert alert-success"><?= htmlspecialchars($msg) ?></div>
  <?php endif; ?>

  <div class="card">
    <div class="card-body">
      <h5 class="card-title mb-3">💰 Price Range Margin</h5>
      <form method="post">
        <div class="mb-3">
          <label for="price_range_margin" class="form-label">Margin (%)</label>
          <input type="number" step="0.1" min="0" id="price_range_margin" name="price_range_margin"
                 value="<?= htmlspecialchars($rangeMargin) ?>" class="form-control" required>
          <div class="form-text">Example: 15 means ±15% range on the total price.</div>
        </div>
        <button type="submit" class="btn btn-primary">💾 Save</button>
      </form>
    </div>
  </div>
</div>
</body>
</html>
