<?php
// admin/edit_item.php
require_once '../config.php';
if (!isset($_SESSION['admin_user'])) header('Location: index.php');

$id = isset($_GET['id']) ? intval($_GET['id']) : 0;
$category_id = isset($_GET['category_id']) ? intval($_GET['category_id']) : 0;
$error = '';
$success = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $label = $conn->real_escape_string($_POST['label']);
    $value_key = isset($_POST['value_key']) ? $conn->real_escape_string($_POST['value_key']) : '';
    $price = floatval($_POST['price']);
    $active = isset($_POST['active']) ? 1 : 0;
    $category_id = intval($_POST['category_id']);
    $max_qty = isset($_POST['max_qty']) ? intval($_POST['max_qty']) : 10; // default 10 if not set

    if ($id) {
        $conn->query("
            UPDATE items 
            SET 
                label='{$label}', 
                value_key='{$value_key}', 
                price='{$price}', 
                active='{$active}', 
                max_qty='{$max_qty}' 
            WHERE id={$id}
        ");
        $success = 'Updated';
    } else {
        $conn->query("
            INSERT INTO items (category_id,label,value_key,price,active,max_qty) 
            VALUES ({$category_id},'{$label}','{$value_key}','{$price}','{$active}','{$max_qty}')
        ");
        $success = 'Added';
        $id = $conn->insert_id;
    }
}

$item = null;
if ($id) {
    $res = $conn->query("SELECT * FROM items WHERE id={$id} LIMIT 1");
    $item = $res->fetch_assoc();
}

$cats = $conn->query("SELECT * FROM categories ORDER BY sort_order");
?>

<!doctype html>
<html>
<head>
  <meta charset="utf-8">
  <title><?= $item ? 'Edit' : 'Add' ?> Item</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body { background: #f8f9fa; }
    .btn-sm { padding: 0.25rem .5rem; }
  </style>
</head>
<body>
<div class="container py-4">

  <!-- Top Admin Buttons -->
  <div class="d-flex justify-content-between align-items-center mb-4">
    <h3 class="mb-0">⚙️ Calculator Admin Panel</h3>
    <div>
      <a href="../index.php" target="_blank" class="btn btn-sm btn-outline-success me-2">
      🔢 View Calculator
      </a>
      <a href="dashboard.php" class="btn btn-sm btn-outline-primary me-2">Dashboard</a>
      <a href="settings.php" class="btn btn-sm btn-outline-info me-2">Settings</a>
      <a href="profile.php" class="btn btn-sm btn-outline-secondary me-2">Profile</a>
      <a href="logout.php" class="btn btn-sm btn-danger">Logout</a>
    </div>
  </div>

  <!-- Back Button -->
  <a href="dashboard.php" class="btn btn-sm btn-outline-secondary mb-3">← Back</a>

  <div class="card p-3">
    <h5><?= $item ? 'Edit' : 'Add' ?> Item</h5>

    <?php if ($error): ?><div class="alert alert-danger"><?= esc($error) ?></div><?php endif; ?>
    <?php if ($success): ?><div class="alert alert-success"><?= esc($success) ?></div><?php endif; ?>

    <form method="post">
      <div class="mb-2">
        <label>Category</label>
        <select name="category_id" class="form-select" required>
          <?php while ($c = $cats->fetch_assoc()): ?>
            <option value="<?= esc($c['id']) ?>" <?= ($item && $item['category_id'] == $c['id']) || ($category_id == $c['id'] && !$item) ? 'selected' : '' ?>>
              <?= esc($c['title']) ?> (<?= esc($c['slug']) ?>)
            </option>
          <?php endwhile; ?>
        </select>
      </div>

      <div class="mb-2">
        <label>Label</label>
        <input class="form-control" name="label" value="<?= esc($item['label'] ?? '') ?>" required>
      </div>

      <div class="mb-2">
        <label>Value Key (optional - e.g. zipcode)</label>
        <input class="form-control" name="value_key" value="<?= esc($item['value_key'] ?? '') ?>">
      </div>

      <div class="mb-2">
        <label>Price (for frequency store discount %)</label>
        <input type="number" step="0.01" class="form-control" name="price" value="<?= esc($item['price'] ?? '0.00') ?>" required>
      </div>

      <div class="mb-2">
        <label>Max Quantity (for extras or items with quantity)</label>
        <input type="number" class="form-control" name="max_qty" value="<?= esc($item['max_qty'] ?? '10') ?>" min="1">
      </div>

      <div class="form-check mb-3">
        <input type="checkbox" class="form-check-input" id="active" name="active" <?= (!isset($item['active']) || $item['active']) ? 'checked' : '' ?>>
        <label class="form-check-label" for="active">Active</label>
      </div>

      <button class="btn btn-primary"><?= $item ? 'Save' : 'Add' ?></button>
    </form>
  </div>
</div>
</body>
</html>
