<?php
// admin/edit_category.php
require_once '../config.php';
if(!isset($_SESSION['admin_user'])) header('Location: index.php');

// Helper to create URL-friendly slugs
function create_slug($string) {
    $slug = strtolower(trim($string));
    $slug = preg_replace('/[^a-z0-9\s-]/', '', $slug); // remove invalid chars
    $slug = preg_replace('/[\s-]+/', '-', $slug); // replace spaces & multiple hyphens with single hyphen
    return $slug;
}

$id = isset($_GET['id']) ? intval($_GET['id']) : 0;
$title = '';
$input_type = 'select';
$sort_order = 0;
$error = '';
$success = '';

if($id) {
    $r = $conn->query("SELECT * FROM categories WHERE id=" . intval($id) . " LIMIT 1");
    if($r && $row = $r->fetch_assoc()){
        $title = $row['title'];
        $input_type = $row['input_type'];
        $sort_order = $row['sort_order'];
    }
}

if($_SERVER['REQUEST_METHOD'] === 'POST'){
    $title = $conn->real_escape_string($_POST['title'] ?? '');
    $input_type = $conn->real_escape_string($_POST['input_type'] ?? 'select');
    $sort_order = intval($_POST['sort_order'] ?? 0);
    $slug = $conn->real_escape_string(create_slug($title));

    if(trim($title) === '') {
        $error = 'Title is required.';
    } else {
        if($id){
            $conn->query("UPDATE categories 
                         SET title='{$title}', slug='{$slug}', input_type='{$input_type}', sort_order={$sort_order} 
                         WHERE id={$id} LIMIT 1");
            $success = 'Category updated.';
        } else {
            $conn->query("INSERT INTO categories (title, slug, input_type, sort_order) 
                         VALUES ('{$title}', '{$slug}', '{$input_type}', {$sort_order})");
            $id = $conn->insert_id;
            $success = 'Category added.';
        }
        header("Location: dashboard.php?msg=" . urlencode($success));
        exit;
    }
}
?>
<!doctype html>
<html>
<head>
  <meta charset="utf-8">
  <title><?= $id ? 'Edit' : 'Add' ?> Category</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body { background: #f8f9fa; }
    .btn-sm { padding: 0.25rem .5rem; }
  </style>
</head>
<body>
<div class="container py-4">

  <!-- Top Admin Buttons -->
  <div class="d-flex justify-content-between align-items-center mb-4">
    <h3 class="mb-0">⚙️ Calculator Admin Panel</h3>
    <div>
      <a href="../index.php" target="_blank" class="btn btn-sm btn-outline-success me-2">
      🔢 View Calculator
      </a>
      <a href="dashboard.php" class="btn btn-sm btn-outline-primary me-2">Dashboard</a>
      <a href="settings.php" class="btn btn-sm btn-outline-info me-2">Settings</a>
      <a href="profile.php" class="btn btn-sm btn-outline-secondary me-2">Profile</a>
      <a href="logout.php" class="btn btn-sm btn-danger">Logout</a>
    </div>
  </div>

  <!-- Back Button -->
  <a href="dashboard.php" class="btn btn-sm btn-secondary mb-3">&larr; Back</a>

  <div class="card p-4">
    <h4><?= $id ? 'Edit' : 'Add' ?> Category</h4>
    <?php if($error): ?><div class="alert alert-danger"><?= esc($error) ?></div><?php endif; ?>
    <form method="post">
      <div class="mb-3">
        <label class="form-label">Title</label>
        <input name="title" class="form-control" value="<?= esc($title) ?>" required>
      </div>
      <div class="mb-3">
        <label class="form-label">Input Type</label>
        <select name="input_type" class="form-select">
            <option value="select" <?= $input_type === 'select' ? 'selected' : '' ?>>Select</option>
            <option value="radio" <?= $input_type === 'radio' ? 'selected' : '' ?>>Radio</option>
            <option value="checkbox" <?= $input_type === 'checkbox' ? 'selected' : '' ?>>Checkbox</option>
            <option value="zipcode" <?= $input_type === 'zipcode' ? 'selected' : '' ?>>Zipcode</option>
        </select>
      </div>
      <div class="mb-3">
        <label class="form-label">Sort Order</label>
        <input name="sort_order" type="number" class="form-control" value="<?= intval($sort_order) ?>">
      </div>
      <button class="btn btn-primary"><?= $id ? 'Save' : 'Add' ?></button>
    </form>
  </div>
</div>
</body>
</html>
