<?php
// admin/dashboard.php
require_once '../config.php';

if (!isset($_SESSION['admin_user'])) {
    header('Location: index.php');
    exit;
}

$msg = $_GET['msg'] ?? '';

// Load categories and related items
$categories = [];
$res = $conn->query("SELECT * FROM categories ORDER BY sort_order");
while ($c = $res->fetch_assoc()) {
    $categories[$c['id']] = $c;
    $categories[$c['id']]['items'] = [];
}
$resItems = $conn->query("SELECT * FROM items ORDER BY category_id, sort_order");
while ($it = $resItems->fetch_assoc()) {
    if (isset($categories[$it['category_id']])) {
        $categories[$it['category_id']]['items'][] = $it;
    }
}
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <title>Admin Dashboard - Calculator</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- use a single consistent bootstrap -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body { background: #f8f9fa; }
    .card { box-shadow: 0 2px 6px rgba(0,0,0,0.06); border-radius: 10px; }
    .category-header { border-bottom: 1px solid #ececec; padding-bottom: 8px; margin-bottom: 10px; }
    .table th { background: #fafafa; }
    .btn-sm { padding: 0.25rem .5rem; }
  </style>
</head>
<body>
<div class="container py-4">
  <div class="d-flex justify-content-between align-items-center mb-4">
    <h3 class="mb-0">⚙️ Calculator Admin Panel</h3>
    <div>
      <a href="../index.php" target="_blank" class="btn btn-sm btn-outline-success me-2">
      🔢 View Calculator
      </a>
      <a href="dashboard.php" class="btn btn-sm btn-outline-primary me-2">Dashboard</a>
      <a href="settings.php" class="btn btn-sm btn-outline-info me-2">Settings</a>
      <a href="profile.php" class="btn btn-sm btn-outline-secondary me-2">Profile</a>
      <a href="logout.php" class="btn btn-sm btn-danger">Logout</a>
    </div>
  </div>

  <?php if ($msg): ?>
    <div class="alert alert-success"><?= esc($msg) ?></div>
  <?php endif; ?>

  <div class="row">
    <?php if (!empty($categories)): ?>
      <?php foreach ($categories as $c): ?>
        <div class="col-md-6 mb-4">
          <div class="card p-3 h-100">
            <div class="d-flex justify-content-between align-items-center category-header">
              <h5 class="mb-0"><?= esc($c['title']) ?>
                <small class="text-muted">[<?= esc($c['input_type']) ?>]</small>
              </h5>
              <div>
                <a href="edit_category.php?id=<?= urlencode($c['id']) ?>" class="btn btn-sm btn-outline-primary">Edit</a>
                <a href="edit_item.php?category_id=<?= urlencode($c['id']) ?>" class="btn btn-sm btn-success">Add Item</a>
              </div>
            </div>

            <?php if (!empty($c['items'])): ?>
              <div class="table-responsive">
                <table class="table table-sm align-middle mb-0">
                  <thead>
                    <tr>
                      <th>Label</th>
                      <th class="text-end">Price</th>
                      <th>Status</th>
                      <th>Actions</th>
                    </tr>
                  </thead>
                  <tbody>
                    <?php foreach ($c['items'] as $it): ?>
                      <tr>
                        <td><?= esc($it['label']) ?></td>
                        <td class="text-end">$<?= number_format((float)$it['price'], 2) ?></td>
                        <td>
                          <span class="badge bg-<?= $it['active'] ? 'success' : 'secondary' ?>">
                            <?= $it['active'] ? 'Active' : 'Inactive' ?>
                          </span>
                        </td>
                        <td>
                          <a href="edit_item.php?id=<?= urlencode($it['id']) ?>" class="btn btn-sm btn-outline-primary">Edit</a>
                          <a href="delete.php?t=items&id=<?= urlencode($it['id']) ?>"
                             class="btn btn-sm btn-outline-danger"
                             onclick="return confirm('Are you sure you want to delete this item?');">
                             Delete
                          </a>
                        </td>
                      </tr>
                    <?php endforeach; ?>
                  </tbody>
                </table>
              </div>
            <?php else: ?>
              <p class="text-muted fst-italic mb-0">No items yet.</p>
            <?php endif; ?>
          </div>
        </div>
      <?php endforeach; ?>
    <?php else: ?>
      <div class="col-12 text-center py-5">
        <p class="text-muted fs-5">No categories found. Add one to get started.</p>
      </div>
    <?php endif; ?>
  </div>

  <hr class="my-4">
  <a href="edit_category.php" class="btn btn-primary">➕ Add New Category</a>
  
</div>
</body>
</html>
