<?php

require_once 'config.php';
// Load price range margin setting
$rangeMargin = 15; // default fallback
$res = $conn->query("SELECT value FROM settings WHERE name='price_range_margin'");
if ($res && $row = $res->fetch_assoc()) {
    $rangeMargin = (float)$row['value'];
}
// echo $rangeMargin;

/* Load categories and items in structured array */
$cats = [];

$catRes = $conn->query("SELECT * FROM categories ORDER BY sort_order");

while ($c = $catRes->fetch_assoc()) {

  $cats[$c['id']] = $c;

  $cats[$c['id']]['items'] = [];
}

$itemRes = $conn->query("SELECT * FROM items WHERE active=1 ORDER BY category_id, sort_order");

while ($it = $itemRes->fetch_assoc()) {

  if (isset($cats[$it['category_id']])) {

    $cats[$it['category_id']]['items'][] = $it;
  }
}

?>


<!doctype html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <title>Cleaning Calculator</title>
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="assets/css/style.css?ver=<?= time(); ?>" rel="stylesheet">
</head>

<body>
  <div class="container py-4">
    <div class="d-flex justify-content-end mt-3 mb-3">
      <a href="admin/index.php" class="btn btn-primary" target="_blank">
        Go to Admin Panel
      </a>
    </div>
    <div class="calc-columns">

      <!-- Left column: Bedrooms, Bathrooms, Sqft, Zipcode -->
      <div class="calc-left">
        <div class="card left-card">
          <h4>Cleaning Details</h4>
          <form id="calcForm">
            <?php foreach ($cats as $cat): ?>
              <?php if (in_array($cat['slug'], ['zipcodes', 'bedrooms', 'bathrooms', 'square-foot-range'])): ?>
                <div class="mb-3">
                  <label class="form-label fw-semibold"><?= esc($cat['title']) ?></label>
                  <?php if ($cat['input_type'] === 'select' || $cat['input_type'] === 'zipcode'): ?>
                    <select class="form-select calc-field" data-category="<?= esc($cat['slug']) ?>">
                      <option value="">-- Select --</option>
                      <?php foreach ($cat['items'] as $it): ?>
                        <option data-price="<?= esc($it['price']) ?>" value="<?= esc($it['id']) ?>"><?= esc($it['label']) ?></option>
                      <?php endforeach; ?>
                    </select>
                  <?php endif; ?>
                </div>
              <?php endif; ?>
            <?php endforeach; ?>
            <!-- Partial Cleaning Items (like extras) -->
            <!-- Partial Cleaning Items (like Extras) -->
            <?php if (isset($cats[7])): ?>
              <!-- Partial Cleaning Toggle -->
              <div class="form-check mb-2">
                <input type="checkbox" class="form-check-input" id="partialToggle">
                <label class="form-check-label fw-semibold" for="partialToggle">
                  Partial Cleaning
                </label>
              </div>

              <div class="partial-items-container mb-3" style="display:none;">
                <div class="row g-2">
                  <?php foreach ($cats[7]['items'] as $it): ?>
                    <div class="col-6 col-md-4">
                      <div class="extras-box position-relative text-center">
                        <!-- Quantity selector -->
                        <div class="quantity-selector align-items-center justify-content-center">
                          <button type="button" class="qty-minus">−</button>
                          <input type="number"
                            min="1"
                            max="<?= esc($it['max_qty'] ?? 10) ?>"
                            value="1"
                            class="qty-input"
                            readonly
                            style="text-align:center;">
                          <button type="button" class="qty-plus">+</button>
                        </div>
                        <!-- Hidden checkbox -->
                        <input type="checkbox" class="extras-box-input d-none"
                          id="partial-<?= esc($it['id']) ?>"
                          data-price="<?= esc($it['price']) ?>"
                          data-item-id="<?= esc($it['id']) ?>"
                          data-max="<?= esc($it['max_qty'] ?? 10) ?>">
                        <!-- Label -->
                        <label class="extras-box-label w-100" for="partial-<?= esc($it['id']) ?>">
                          <?= esc($it['label']) ?>
                        </label>
                      </div>
                    </div>
                  <?php endforeach; ?>
                </div>
              </div>
            <?php endif; ?>

            <!--<button type="button" id="resetBtn" class="btn btn-outline-secondary mt-2">Reset</button>-->
          </form>
        </div>
      </div>

      <!-- Center column: Frequency + Extras -->
      <div class="calc-center">
        <!-- Frequency Card -->
        <?php foreach ($cats as $cat): ?>
          <?php if ($cat['slug'] === 'frequency'): ?>
            <div class="card freq-card">
              <h4><?= esc($cat['title']) ?></h4>
              <div class="freq-toggle">
                <?php foreach ($cat['items'] as $it): ?>
                  <div>
                    <input type="radio" class="btn-check calc-field"
                      name="frequency"
                      id="freq-<?= esc($it['id']) ?>"
                      data-price="<?= esc($it['price']) ?>"
                      data-category="<?= esc($cat['slug']) ?>" value="<?= esc($it['id']) ?>">
                    <label class="btn" for="freq-<?= esc($it['id']) ?>">
                      <?= esc($it['label']) ?>
                    </label>
                  </div>
                <?php endforeach; ?>
              </div>
            </div>
          <?php endif; ?>
        <?php endforeach; ?>

        <!-- Extras Card -->
        <?php foreach ($cats as $cat): ?>
          <?php if ($cat['slug'] === 'extras'): ?>
            <div class="card extras-card">
              <h4><?= esc($cat['title']) ?></h4>
              <div class="extras-container">
                <?php
                // Reorder extras so that "Deep Cleaning", "Move In Out", and "Post Construction" are last in that order
                $extras = $cat['items'];
                $specialOrder = ['Deep Cleaning', 'Move In Out', 'Post Construction'];

                $special = [];
                $regular = [];

                foreach ($extras as $it) {
                  $label = trim($it['label']);
                  if (in_array($label, $specialOrder, true)) {
                    $special[$label] = $it;
                  } else {
                    $regular[] = $it;
                  }
                }

                // Merge normal items + special items in correct order
                $reordered = array_merge($regular, array_filter([
                  $special['Deep Cleaning'] ?? null,
                  $special['Move In Out'] ?? null,
                  $special['Post Construction'] ?? null,
                ]));
                ?>

                <?php foreach ($reordered as $it): ?>


                  <div class="extras-box position-relative text-center">
                    <!-- Quantity selector ABOVE the box -->
                    <div class="quantity-selector align-items-center justify-content-center">
                      <button type="button" class="qty-minus">−</button>
                      <input type="number"
                        min="1"
                        max="<?= esc($it['max_qty'] ?? 10) ?>"
                        value="1"
                        class="qty-input"
                        readonly
                        style="text-align:center;">
                      <button type="button" class="qty-plus">+</button>
                    </div>
                    <!-- Checkbox and label -->
                    <input type="checkbox" class="extras-box-input d-none"
                      id="extra-<?= esc($it['id']) ?>"
                      data-price="<?= esc($it['price']) ?>"
                      data-item-id="<?= esc($it['id']) ?>"
                      data-max="<?= esc($it['max_qty'] ?? 10) ?>">
                    <label class="extras-box-label w-100" for="extra-<?= esc($it['id']) ?>">
                      <?= esc($it['label']) ?>
                    </label>
                  </div>
                <?php endforeach; ?>
              </div>
            </div>
          <?php endif; ?>
        <?php endforeach; ?>
      </div>

      <!-- Right column: Summary -->
      <div class="calc-right">
        <div class="card summary-card" id="summaryCard">
          <div class="summary-header">
            <span id="summaryHeaderText">View Summary</span>
            <span id="summaryHeaderTotal" style="font-weight:600; margin-left:6px;">$0.00</span>
          </div>

          <div class="summary-body">
            <h4>Summary</h4>
            <ul class="list-group mb-3" id="summaryList"></ul>
            <div class="d-flex justify-content-between align-items-center">
              <div>Subtotal:</div>
              <div id="subtotal">$0.00</div>
            </div>
            <div class="d-flex justify-content-between align-items-center">
              <div>Discount (frequency):</div>
              <div id="discount">-$0.00</div>
            </div>
            <hr>
            <div class="d-flex justify-content-between align-items-center fs-4 fw-bold">
              <div>Total:</div>
              <div id="total">$0.00</div>
            </div>
            <div class="d-flex justify-content-between align-items-center text-muted mt-1">
              <div>High:</div>
              <div id="rangeHigh">$0.00</div>
            </div>
            <div class="d-flex justify-content-between align-items-center text-muted">
              <div>Low:</div>
              <div id="rangeLow">$0.00</div>
            </div>

            <div class="d-flex flex-column gap-2 mt-3">
              <button type="button" id="resetBtn" class="btn btn-outline-secondary w-100">Reset</button>
            </div>
          </div>
        </div>
      </div>
      
    </div>
  </div>

  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
  <script>
    const PRICE_RANGE_MARGIN = <?= json_encode($rangeMargin) ?>;
  </script>
  <script src="assets/js/app.js?ver=<?= time(); ?>"></script>

</body>

</html>